# Frequently Asked Questions
**1. When compiling C/C++ Example under Windows, the dll library cannot be found when running.**
* All the dlls needed for running are in the bin directory of Examples. Copy the dll files in the directory to the executable file.

**2. When compiling C/C++ under Linux, it prompts that libudev is missing?**
* udev is integrated by default in the support system. If it is missing, you can install it through apt-get install libudev0 and then recompile it.

**3. Cmake compiles C++ programs with errors "Found OpenCV Windows Pack but it has no binaries compatible with your configuration. You should manually point CMake variable OpenCV_DIR to your build of OpenCV library"？**
* Configure OpenCV_DIR as the location of the OpenCVConfig.cmake file. There are differences between different versions. It is common in the opencv\build directory. After configuration, it still reports an error "but it set OpenCV_FOUND to FALSE so package "OpenCV" is considered to be NOT FOUND." You can try to set it to the opencv/build/x64/vc15/lib directory.

**4.The depth image no longer refreshes after the Astra+ device D2C mode is switched on/off.**
* In the current version, the D2C switch needs to be controlled when the depth stream is off, and restarting the depth stream will restore it to normal. The use of D2C will be broadened in subsequent version updates, so that D2C can also be used even when the stream is on.

**5. The depth image and infrared image of the Femto device are no longer refreshed.**
* To ensure the user experience, Femto only works when the depth and infrared image resolutions are the same (both 640*480 or 320*240).

**6. When compiling C/C++ Example under Windows, an error is reported when running, saying "Because opencv_world.dll cannot be found, the code cannot be executed, reinstalling the program may solve the problem".**
* The problem is due to the inconsistency between the opencv version in the running environment and the sample version (opencv_world430.dll) in the sample. You need to manually copy the corresponding version of dll (such as opencv_world435.dll) from the bin directory under opencv/build to the Examples/build/bin/ Release folder, and run it again to solve the problem.

**7. Hot-plugging under Ubuntu, the device cannot be used normally, prompting "failed to open usb device: error: OB_USB_STATUS_ACCESS".**

If you encounter this scenario when using, you can try the following methods:
* Using the terminal: After hot plugging, you need to re-authorize the USB device (sudo chmod 777 /dev/bus/usb/00x/*).
* Use the OrbbecViewer tool: After hot plugging, authorize the tool (sudo ./OrbbecViewer) to restore normal.

**8. The point cloud display is abnormal under Linux.**
* Please check if your graphics card driver is installed or in a normal state. Point cloud rendering relies on OpenGL, and OpenGL needs the GPU for rendering. Reinstall the graphics card driver to fix it.

**9. After the PC is connected to the device normally, it fails to open the device.**
* Try to uninstall the DataChannel in the device manager and then re-plug the device to solve the problem

**10. After some Windows computers have used devices with older versions of firmware, devices with newer versions of firmware cannot be enumerated or fail to upgrade.**

* Because the device name in the device descriptor of the new firmware may have changed, but the old device name information is still cached in the Windows registry, which makes it impossible to enumerate. To solve this problem, you need to uninstall the device in the device manager and reinsert it. Unplug the device, or use the devcon tool to delete the registry and then plug and unplug the device to solve the problem.

**11、Some Windows computers will crash when using OrbbecViewer.**

* You need to install the latest graphics card driver and USB driver, you can download from the corresponding official website

**12、Console prompt Create glfw windows failed!**

* Usually the graphics driver is not installed, and this problem can be solved by installing the graphics driver

**13、Ubuntu 16.04 environment, point cloud display black screen.**

* Make sure that the OpenGL version on your system is greater than 3.3

**14、Gemini2 device depth has a scaling factor, and the scaling factor values are: 0.1, 0.2, 0.4, 0.8, 1.0.**

 * After obtaining the depth value through the SDK, it needs to be multiplied by the scaling factor to obtain the depth value in millimeters. 
 For example, valueScale=0.1, and the pixel value of a certain coordinate is pixelValue=10000, which means the depth value = pixelValue*valueScale = 10000*0.1=1000mm.
 Obtain the scaling factor through the following interface.
  
C API：
``` bash
float ob_depth_frame_get_value_scale(ob_frame *frame, ob_error **error);
```

C++ API：
``` bash
DepthFrame class float getValueScale();
```


**15、SyncAlignViewer Sample（c++）D2C cannot be aligned**
* First, copy the OrbbecSDKConfig_v1.0.xml configuration file to the bin directory of the compiled Sample. If there is no configuration file, you need to use the SDK interface to set the depth and color resolution that can be aligned, and then open the stream.
* Dabai DCW and Gemini E have special alignment resolutions, and the resolutions of hardware alignment and software alignment are different. Please refer to the product manual to modify the configuration file, or use the SDK interface to configure the correct resolution to open stream. Such as: DCW and Gemini E, hardware aligned resolution Depth 640x360 is aligned to Color 640x360, and software aligned resolution Depth 640x480 is aligned to Color 640x360.

16. **Arm platforms (A311D, Raspberry Pi 4B, etc.) OrbbecViewer point clouds cannot be rendered**
* The system OpenGL version is too low, and OrbbecViewer point cloud rendering requires OpenGL version greater than 3.3.

17. **Arm platform, MultiDevice, MultiStream, MultiDeviceSync sample cannot be rendered**
*  Opencv that the application depends on is trimmed and is not supported. Users must use Opencv 4.2 or above, recompile the sample, and it can be rendered.

# Changelog
Orbbec SDK 1.8.3 Major updates
* Fix issue where OpenNI supported cameras cannot retrieve depth intrinsics from the pipeline
* Fix Femto Mega/Femto Bolt failure to open the stream due to abnormal shutdown (stream not properly closed)
* Fix crash on exit for samples with rendering 
* Other bug fixes and optimizations




# Legal information
## Copyright notice and license link
* [OpenCV](https://github.com/opencv/opencv/blob/master/LICENSE)
* [OpenGL](https://www.khronos.org/legal/)
* [ImGui](https://github.com/ocornut/imgui/blob/master/LICENSE.txt)
